

#
# This is a test script to show how users could be managed using PERL and
# the virtual files on the admin volume.  This script allows for the addition
# and deletion of users.  When a user is added a directory is created for 
# him, he is added to NDS and he is assigned as a trustee to the directory
# that was created.  A user space restriction is also placed on the volume.
#
use File::Path;

$server = "kona";
$volume = "nss1";
$dir = "users";
$targetDir = "\\\\$server\\$volume\\$dir\\";

#
# Set the datastream for a file handle to the passed in value.
#
sub SetDataStream(*$)
{
	my $fh = $_[0];
	my $dataStream = $_[1];

	my $result;
	my $command;

	$command = "<virtualIO><datastream name=\"$dataStream\"/></virtualIO>";
	seek $fh, 0, 0;
	if (!syswrite($fh, $command, length($command)))	
	{
		$result .= "Unable to send datastream command to NDS management.  ";
		seek $fh, 0, 0;
		if (sysread($fh, $error, 1000)) 
		{
			$result .= $error;
		}
		$result .= "\n";
	}
	return $result;
}

#
# Write a command to a file and get the result
#
sub WriteCommand(*$)
{
	my $fh = $_[0];
	my $command = $_[1];

	my $result;

#	print("command=$command\n");
	seek $fh, 0, 0;
	if (!syswrite($fh, $command, length($command)))
	{
		$result .= "Unable to send command to virtual file.  ";
		seek $fh, 0, 0;
		if (sysread($fh, $error, 1000)) 
		{
			$result .= $error;
		}
		$result .= "\n";
	}
	else
	{
		seek $fh, 0, 0;
		sysread($fh, $reply, 1000);
		$result .= $reply;
	}
#	print("result=$result\n");
	return $result;
}

#
# Parse the result of adding an NDS user
#
sub ParseNDSResult($$)
{
	my $xml = $_[0];
	my $name = $_[1];
	my $addUser = "";
	my $removeUser = "";

	print "ndsResult xml=$xml\n";
	if ($xml =~ /<addUser>(.*)<\/addUser>/s)
	{
		$addUser = $1;
		if ($addUser =~ /<result value=\"(-?\d+)\">/s)
		{
			if ($1 == 0)
			{
				return "$name successfully added to NDS\n";
			}
			else
			{
				if ($1 == -606)
				{
					return "$name already exists as a user object in NDS\n";
				}
				else
				{
					return "Error $1 adding $name to NDS\n";
				}
			}
		}
	}
	elsif ($xml =~ /<removeUser>(.*)<\/removeUser>/s)
	{
		$removeUser = $1;
		if ($removeUser =~ /<result value=\"(-?\d+)\">/s)
		{
			if ($1 == 0)
			{
				return "$name successfully removed from NDS\n";
			}
			else
			{
				if ($1 == -601)
				{
					return "user $name not found in NDS\n";
				}
				else
				{
					return "Error $1 removing $name from NDS\n";
				}
			}
		}
	}
	else
	{
		return "Error parsing results of NDS operation\n";
	}
}

#
# Parse the result of the NSS operations
#
sub ParseNSSResult($$$)
{
	my $xml = $_[0];
	my $name = $_[1];
	my $file = $_[2];
	my $addUser = "";
	my $addQuota = "";

#	print "nssResult xml=$xml\n";
	if ($xml =~ /<addTrustee>(.*)<\/addTrustee>/s)
	{
		$addUser = $1;
		if ($addUser =~ /<result value=\"(-?\d+)\">/s)
		{
			if ($1 == 0)
			{
				return "Trustee $name successfully added to $file\n";
			}
			else
			{
				return "Error $1 adding trustee $name to $file\n";
			}
		}
	}
	elsif ($xml =~ /<addQuota>(.*)<\/addQuota>/s)
	{
		$addQuota = $1;
		if ($addQuota =~ /<result value=\"(-?\d+)\">/s)
		{
			if ($1 == 0)
			{
				return "Quota for $name successfully added to $file\n";
			}
			else
			{
				return "Error $1 adding quota $name to $file\n";
			}
		}
	}
	else
	{
		return "Error parsing results of NSS operation\n";
	}
}

#
# Add a list of users
#
sub AddUsers 
{
	my @names = @_;
	my @results;
	my $result;
	my $ret;

	for my $name (@names) 
	{
		$result = "Processing user \"$name\"\n";
		#
		# Add a user to NDS
		#
		if (!($ret = SetDataStream(NDSFILE, "command")))
		{
			$result .= $ret;

			$name =~ /(\w*$)/;
			my $surname = $1;

			$name =~ /(^\w*)/;
			my $givenName = $1;

			my $ndsResult = WriteCommand(NDSFILE, 
						"<ndsRequest><ndsUser><addUser>".
						"<name>$name</name>".
						"<context>".$server."_tree\\novell</context>".
						"<surname>$surname</surname>".
						"<fullName>$name</fullName>".
						"<givenName>$givenName</givenName>".
						"<userDescription>Auto added user</userDescription>".
						"<password>password</password>".
						"</addUser></ndsUser></ndsRequest>");
			$result .= ParseNDSResult($ndsResult, $name);
		}
		#
		# Add a new directory
		#
		if (!(-e "$targetDir"))
		{
			if (!mkdir($targetDir))
			{
				$result .= "Unable to create directory $targetDir\n";
			}
		}
		if (-e "$targetDir\\$name")
		{
			$result .= "Directory $targetDir$name already exists\n";
		}
		else
		{
			if (!mkdir("$targetDir\\$name"))
			{
				$result .= "Unable to create directory $targetDir$name\n";
			}
			else {
				$result .= "Created directory $targetDir$name\n";
			}
		}
		#
		# Add a trustee to the directory
		#
		if (!($ret .= SetDataStream(NSSFILE, "command")))
		{
			$result .= $ret;
			my $nssResult = WriteCommand(NSSFILE, 
						"<nssRequest><authorizeNW><addTrustee>".
						"<context>".$server."_tree\\novell</context>".
						"<fileName>$volume:$dir\\$name</fileName>".
						"<name>$name</name><rights>rwfce</rights>".
						"</addTrustee></authorizeNW></nssRequest>");
			$result .= ParseNSSResult($nssResult, $name, "$targetDir$name");
		}
		#
		# Add a directory restriction to the directory
		#
		if (!($ret .= SetDataStream(NSSFILE, "command")))
		{
			$result .= $ret;
			my $nssResult = WriteCommand(NSSFILE, 
						"<nssRequest><directoryQuota><addQuota>".
						"<fileName>$volume:$dir\\$name</fileName>".
						"<quotaAmount>100000000</quotaAmount>".
						"</addQuota></directoryQuota></nssRequest>");
			$result .= ParseNSSResult($nssResult, $name, "$targetDir$name");
		}
		push @results, $result;
	}
	return @results;
}
	
#
# Remove a list of users
#
sub RemoveUsers 
{
	my @names = @_;
	my @results;
	my $result;
	my $ret;

	for my $name (@names) 
	{
		$result = "Processing user \"$name\"\n";
		#
		# Remove a user from NDS
		#
		if (!($ret = SetDataStream(NDSFILE, "command")))
		{
			$result .= $ret;
			my $ndsResult = WriteCommand(NDSFILE, 
						"<ndsRequest><ndsUser><removeUser>".
						"<name>$name</name>".
						"<context>".$server."_tree\\novell</context>".
						"</removeUser></ndsUser></ndsRequest>");
			$result .= ParseNDSResult($ndsResult, $name);
		}
		#
		# Remove the directory
		#
		if (-e "$targetDir\\$name")
		{
			if (rmtree("$targetDir\\$name", 0, 0))
			{
				$result .= "Removed directory $targetDir$name\n";
			}
			else 
			{
				$result .= "Unable to remove directory $targetDir$name\n";
			}
		}
		else
		{
			$result .= "Directory $targetDir$name does not exists\n";
		}
		push @results, $result;
	}
	return @results;
}
	
#
# Main
#
open(NSSFILE, "+<\\\\$server\\_admin\\Manage_NSS\\manage.cmd") 
	or die "Error opening NSS management file ($!)";

open(NDSFILE, "+<\\\\$server\\_admin\\Manage_NSS\\NDS.cmd") 
	or die "Error opening NDS management file ($!)";

MAIN: while(TRUE) 
{
	do 
	{
		print	"1. Create users from prompt\n".
				"2. Create users from a file\n".
				"3. Delete users from a prompt\n".
				"4. Delete users from file\n".
				"5. exit\n".
				"Select action: ";
		$action = <STDIN>;
	}while ($action < 1 || $action > 5);

	if ($action == 1) 
	{
		for(;;)
		{
			print "Enter the user name (no name = exit): ";
			chomp($name = <STDIN>);
			if ($name eq "")
			{
				last;
			}
			print "\n---------------------------\n";
			my @results = AddUsers($name);
			print @results;
			print "---------------------------\n\n";
		}
	}
	elsif ($action == 2) 
	{
		print "Enter the file name for the list: ";
		$fileName = <STDIN>;
		open(LISTFILE, "<$fileName") or die "Error opening $fileName ($!)";
		print "\n---------------------------\n\n";
		while (chomp($name = <LISTFILE>))
		{
			my @results = AddUsers($name);
			print @results;
			print "\n";
		}
		print "---------------------------\n\n";
		close(LISTFILE);
	}
	elsif ($action == 3)
	{
		for(;;)
		{
			print "Enter the user name (no name = exit): ";
			chomp($name = <STDIN>);
			if ($name eq "")
			{
				last;
			}
			print "\n---------------------------\n";
			my @results = RemoveUsers($name);
			print @results;
			print "---------------------------\n\n";
		}
	}
	elsif ($action == 4) 
	{
		print "Enter the file name for the list: ";
		$fileName = <STDIN>;
		open(LISTFILE, "<$fileName") or die "Error opening $fileName ($!)";
		print "\n---------------------------\n\n";
		while (chomp($name = <LISTFILE>))
		{
			my @results = RemoveUsers($name);
			print @results;
			print "\n";
		}
		print "---------------------------\n\n";
		close(LISTFILE);
	}
	else
	{
		last MAIN;
	}
}
close(NDSFILE);
close(NSSFILE);
