/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004/12/30 19:40:58 $
 |
 | $RCSfile: nfsAPIs.h,v $
 | $Revision: 1.2 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Defines to be used with the NFS APIs for the NFS Semantic Agent.
 |
 |	For compelete documentation, see "NFS Illustrated" by Brent Callaghan,
 |	Addison-Wesley, 2000, ISBN 0-201-32570-5.
 |
 | WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
 |
 | This header file should ONLY be used for NSS internal development.
 | This includes Semantic Agents (SA) and Loadable Storage Services (LSS).
 | Any other use may cause conflicts which NSS will NOT fix.
 +-------------------------------------------------------------------------*/

#ifndef _NFSAPIS_H_
#define _NFSAPIS_H_

#ifndef _ZOMNI_H_
#include <zOmni.h>
#endif

#ifndef _ZPARAMS_H_
#include <zParams.h>
#endif

#ifndef _CHUNK_H_
#	include <chunk.h>
#endif

typedef enum nfsErr_t
{
	nfs3OK				= 0,	
	nfs3ERR_PERM		= 1,
	nfs3ERR_NOENT		= 2,
	nfs3ERR_ERR_IO		= 3,
	nfs3ERR_NXIO		= 6,
	nfs3ERR_ACCES		= 13,
	nfs3ERR_EXIST		= 17,
	nfs3ERR_XDEV		= 18,
	nfs3ERR_NODEV		= 19,
	nfs3ERR_NOTDIR		= 20,
	nfs3ERR_ISDIR		= 21,
	nfs3ERR_INVAL		= 22,
	nfs3ERR_FBIG		= 27,
	nfs3ERR_NOSPC		= 28,
	nfs3ERR_ROFS		= 30,
	nfs3ERR_MLINK		= 31,
	nfs3ERR_NAMETOOLONG	= 63,
	nfs3ERR_NOTEMPTY	= 66,
	nfs3ERR_DQUOT		= 69,
	nfs3ERR_STALE		= 70,
	nfs3ERR_REMOTE		= 71,
	nfs3ERR_BADHANDLE	= 10001,
	nfs3ERR_NOT_SYNC	= 10002,
	nfs3ERR_BAD_COOKIE	= 10003,
	nfs3ERR_NOT_SUPP	= 10004,
	nfs3ERR_TOOSMALL	= 10005,
	nfs3ERR_SERVERFAULT	= 10006,
	nfs3ERR_BADTYPE		= 10007,
	nfs3ERR_JUKEBOX		= 10008
} nfsErr_t;

enum
{
	zNFS_CAN_SET_ATTR = (zFA_READ_ONLY | zFA_HIDDEN | zFA_SYSTEM
						| zFA_EXECUTE | zFA_RENAME_INHIBIT
						| zFA_DELETE_INHIBIT | zFA_COPY_INHIBIT)
};

typedef struct NFSHandle_s
{
	Zid_t		zid;	/* zid of the file				*/
	VolumeID_t	volID;	/* Id of the volume (a GUID)	*/
} NFSHandle_s;

typedef enum NFSftype3_t
{
	zNF3REG  = 1,		/* Regular file								*/
	zNF3DIR  = 2,		/* Directory								*/
	zNF3BLK  = 3,		/* Block special device (not supported)		*/
	zNF3CHR  = 4,		/* Character special device (not supported) */
	zNF3LNK  = 5,		/* Symbolic link							*/
	zNF3SOCK = 6,		/* Socket (not supported)					*/
	zNF3FIFO = 7		/* Named pipe (not supported, yet)			*/
} NFSftype3_t;

typedef enum FSF3properties_t
{
	zFSF3_LINK			= 0x1,
	zFSF3_SYMLINK		= 0x2,
	zFSF3_HOMOGENEOUS	= 0x8,
	zFSF3_CANSETTIME	= 0x10
} FSF3properties_t;

typedef enum NFSsetAttr_t
{
	zNFS_SET_MODE      = 0x1,
	zNFS_SET_UID       = 0x2,
	zNFS_SET_GID       = 0x4,
	zNFS_SET_SIZE      = 0x8,
	zNFS_SET_ATIME     = 0x10,
	zNFS_SET_MTIME     = 0x20,
	zNFS_CHK_CTIME     = 0x40,
	zNFS_SET_ATTR      = 0x80,
	zNFS_SET_INFO      = 0x100,
	zNFS_SET_INFO_MODE = 0x200,
	zNFS_SET_INFO_UID  = 0x400,
	zNFS_SET_INFO_GID  = 0x800
} NFSsetAttr_t;

typedef enum NFSstableHow_t
{
	zNFS_UNSTABLE, zNFS_DATA_SYNC, zNFS_FILE_SYNC
} NFSstableHow_t;

typedef struct NFStime3_s
{
	LONG	seconds;		/* UTC time								*/
	LONG	nanoSeconds;	/* Fractional time (always set to 0)	*/
} NFStime3_s;

typedef struct NFSspec3_s	/* Here for completeness				*/
{
	LONG	specdata1;
	LONG	specdata2;
} NFSspec3_s;

typedef struct NFSfattr3_s
{
	LONG		type;		/* File type							*/
	LONG		mode;		/* File permissions bits				*/
	LONG		nlink;		/* Number of hard links					*/
	LONG		uid;		/* NetWare owner id						*/
	LONG		gid;		/* File group ID						*/
	QUAD		size;		/* Logical Eof							*/
	QUAD		used;		/* Total blocks used					*/
	NFSspec3_s	rdef;		/* File device information (not used)	*/
	QUAD		fsid;		/* Filesystem identifier (will fake)	*/
	Zid_t		fileid;		/* File number within filesystem		*/
	NFStime3_s	atime;		/* Last access time						*/
	NFStime3_s	mtime;		/* Last modify time						*/
	NFStime3_s	ctime;		/* Last attribute change time			*/
		/*
		 * Non-NFS 3 fields that can be used to fill in the above fields
		 */
	LONG		attributes;	/* NetWare attributes					*/
	NINT		blockSize;	/* Size of the user block				*/
	NINT		blocks;		/* Size of file in blocks				*/
	zUnixInfo_s	unixInfo;	/* Unix Info (no variable data)			*/
	BOOL		isReadOnly;	/* The volume is read only				*/
	Zid_t		parentZid;	/* The 1st Parent Zid for file			*/
} NFSfattr3_s;

typedef struct NF3preOpAttr_s
{
	QUAD		size;		/* Filesystem identifier (will fake)	*/
	NFStime3_s	mtime;		/* Last modify time						*/
	NFStime3_s	ctime;		/* Last attribute change time			*/
} NF3preOpAttr_s;

typedef struct NFSfsinfo_s
{
	LONG		rtmax;
	LONG		rtperf;
	LONG		rtmult;
	LONG		wtmax;
	LONG		wtperf;
	LONG		wtmult;
	LONG		dtpref;
	QUAD		maxfilesize;
	NFStime3_s	time_delta;
	LONG		properties;
} NFSfsinfo_s;

typedef struct NFSfsstat_s
{
	QUAD		tbytes;
	QUAD		fbytes;
	QUAD		abytes;
	QUAD		tfiles;
	QUAD		ffiles;
	QUAD		afiles;
	LONG		invarsec;
	LONG		bsize;
} NFSfsstat_s;

typedef struct NFSReadDir_s
{
	QUAD		cookie;
	NINT		nameLen;	/* Length of the following name	*/
	BYTE		name[zMAX_COMPONENT_NAME + sizeof(NINT)];	/* Null terminated
															 * ascii name
															 */
	Zid_t		zid;
	NFSHandle_s	handle;
	NFSfattr3_s	fattr;
} NFSReadDir_s;

NINT nssToNfsError(NINT status);

void nfssUnpinChunks(
	Chunk_s		*chunks,
	NINT		numChunks);

STATUS nfssChunkyRead(
	NFSHandle_s	*nfsHandle,
	QUAD		offset,
	NINT		bytesToRead,
	NINT		maxChunks,
	Chunk_s		*retChunks,
	NINT		*retNumChunks,
	NINT		*retBytesRead,
	NFSfattr3_s	*fileAttr);

STATUS nfssCreate(
	NFSHandle_s	*parentHandle,
	LONG		ftype,
	BYTE		*name,
	NFSHandle_s	*childHandle,
	NFSfattr3_s	*parentAttr,
	NFSfattr3_s	*childAttr);

STATUS nfssGetAttr(
	NFSHandle_s	*nfsHandle,
	NFSfattr3_s	*fattr);

STATUS nfssGetRootHandle(
	char		*volName,
	NFSHandle_s	*rootHandle);

STATUS nfssFsInfo(
	NFSHandle_s	*nfsHandle,
	NFSfattr3_s	*fattr,
	NFSfsinfo_s	*fsInfo);

STATUS nfssFsStat(
	NFSHandle_s	*nfsHandle,
	NFSfattr3_s	*fattr,
	NFSfsstat_s	*fsStat);

STATUS nfssLink(
	NFSHandle_s		*fromFile,
	NFSHandle_s		*toDir,
	BYTE			*toName,
	NF3preOpAttr_s	*fromPreOpAttr,
	NFSfattr3_s		*fromPostOpFattr,
	NF3preOpAttr_s	*toPreOpAttr,
	NFSfattr3_s		*toPostOpFattr);

STATUS nfssLookup(
	NFSHandle_s	*parentHandle,
	BYTE		*name,
	NFSHandle_s	*childHandle,
	NFSfattr3_s	*parentAttr,
	NFSfattr3_s	*childAttr);

STATUS nfssRead(
	NFSHandle_s	*nfsHandle,
	QUAD		offset,
	NINT		bytesToRead,
	void		*retBuffer,
	NINT		*retBytesRead,
	NFSfattr3_s	*fattr);

STATUS nfssRemove(
	NFSHandle_s		*dirHandle,
	BYTE			*name,
	NF3preOpAttr_s	*preOpAttr,
	NFSfattr3_s		*postOpFattr);

STATUS nfssRename(
	NFSHandle_s		*fromDir,
	BYTE			*fromName,
	NFSHandle_s		*toDir,
	BYTE			*toName,
	NF3preOpAttr_s	*fromPreOpAttr,
	NFSfattr3_s		*fromPostOpFattr,
	NF3preOpAttr_s	*toPreOpAttr,
	NFSfattr3_s		*toPostOpFattr);

STATUS nfssSetAttr(
	NFSHandle_s		*nfsHandle,
	NFSfattr3_s		*newFattr,
	LONG			flags,
	NF3preOpAttr_s	*preOpAttr,
	NFSfattr3_s		*postOpFattr);

STATUS nfssWrite(
	NFSHandle_s		*nfsHandle,
	NINT			howStable,
	QUAD			offset,
	NINT			bytesToWrite,
	void			*userBuf,
	NINT			*retBytesWritten,
	NINT			*howCommitted,
	NF3preOpAttr_s	*preOpAttr,
	NFSfattr3_s		*postOpFattr);

	/*
	 * The set of routines for reading a directory
	 */
STATUS nfssBeginReadDir(
	NFSHandle_s		*dirHandle,
	BOOL			doGetAttr,
	QUAD			cookie,
	NFSReadDir_s	**retReadDir);

STATUS nfssNextReadDir(NFSReadDir_s *readDir);
STATUS nfssEndReadDir(NFSReadDir_s *readDir);
STATUS nfssGetEffectiveRights(
	NFSHandle_s		*nfsHandle,
	LONG			 id, 
	NINT			*effectiveRights);

#endif
