/****************************************************************************
 |
 |	(C) Copyright 1985, 1991, 1993, 1996 Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004/12/30 19:40:58 $
 |
 | $RCSfile: nfsLock.h,v $
 | $Revision: 1.2 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Define data structures used by NFS Lock Manager (NLM).
 |
 | WARNING! WARNING! WARNING! WARNNG! WARNING! WARNING! WARNING! WARNING!
 |
 | This header file should ONLY be used for NSS internal development.
 +-------------------------------------------------------------------------*/


#ifndef _NFSLOCKS_H_
#define _NFSLOCKS_H_

#ifndef _STDDEF_H_
#	include <stddef.h>
#endif
#ifndef _OMNI_H_
#	include <omni.h>
#endif

#ifndef _NFSAPIS_H_
#	include <nfsAPIs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef enum LkMgrStat_t
{
	LKMGR_GRANTED,
	LKMGR_DENIED,
	LKMGR_DENIED_NOLOCKS,
	LKMGR_BLOCKED,
	LKMGR_DENIED_GRACE_PERIOD,
	LKMGR_DEADLCK,
	LKMGR_ROFS,
	LKMGR_STALE_FH,
	LKMGR_FBIG,
	LKMGR_FAILED
} LkMgrStat_t;


typedef enum FshMode_t
{
	FSM_DN,		 /* Deny None */
	FSM_DR,		 /* Deny Read */
	FSM_DW,		 /* Deny Write */
	FSM_DRW		 /* Deny Read and Write */
} FshMode_t;


typedef enum FshAccess_t
{
	FSA_NONE,		 /* No access */
	FSA_R,			 /* Read access */
	FSA_W,			 /* Write access */
	FSA_RW			 /* Read/Write access */
} FshAccess_t;


typedef struct NetObj_s
{
	LONG length;
	LONG data[1];	/* Opaque data, variable length */
} NetObj_s;


/* 
 * In the NLM version 3 protocol, the length and offset are 32 bits wide, while
 * they are 64 bits wide in the NLM version 4 protocol. NLM version 3 should 
 * cast them to 64 bits.
 */
typedef struct LkMgrLock_s
{
	BYTE *callerName;		/* NULL terminated byte string, case insensitive */
	NFSHandle_s *fh;
	NetObj_s *oh;				
	LONG svid;
	QUAD offset;
	QUAD len;
} LkMgrLock_s;


/*----------------------------------------------------------------------------------*
 *----------------------------------------------------------------------------------*/

/************************************************************************************
 * Checks if a lock is available to the client.										*
 * Input:																		    *
 *		testAccess: TRUE: Test if the client could get access (sharable) to the lock*
 *					FALSE: Test if there's a lock existing in the requested region	*
 *		alock: 		the monitored lock that is being tested.						*
 * Output (only will be filled when status is LKMGR_DENIED):						*
 *		isExclusive:TRUE if the conflicting lock is exclusively held				*
 *		svid:		the process id of the lock holder. If the lock holder is a NCP/	*
 *					Windows client, it will be set to 0.							*
 *		oh:			a pointer to lock holder's owner. If the lock holder is a NCP/	*
 *					Windows client, it will be set to NULL.							*
 *		offset:		the conflicting lock's byte offset								*
 *		len:		length, in bytes of the conflicting lock. 						*
 ************************************************************************************/
STATUS LkMgrTest(
	BOOL testAccess,
	LkMgrLock_s *alock,
	BOOL *isExclusive,
	LONG *svid,
	NetObj_s **oh,
	QUAD *offset,
	QUAD *len);


/************************************************************************************
 * Creates a locked byte range on a file											*
 * Note:																			*
 *	1:  If a callback is supplied, the granted lock (either granted immediately or 	*
 *		blocked then granted later) will always be returned through callback 		*
 *		function, while this function returns LKMGR_BLOCKED. This also implies that *
 *		if input parameter "block" is TRUE, callback is a valid value.				*
 *	2:	This function will make a local copy all the necessary information. Caller 	*
 *		can release its related memory if it chooses to do so						*
 ************************************************************************************/
STATUS LkMgrLock(
	NetObj_s *cookie,			  /* NULL terminated byte string */
	BOOL	 block,
	BOOL	 isExclusive,
	LkMgrLock_s *alock,
	SLONG	 state,
	NINT     *callerCount,
	void	 *callback(
			STATUS status,
			NetObj_s *cookie,
			BOOL block,
			BOOL isExclusive,
			NINT callerCount,
			LkMgrLock_s *alock));


/********************************************************************************
 *	Lock Manager will search all the locks on the requested file.				*
 *  return: LCK_GRANTED if lock is found and removed from the waiting list		*
 *			LCK_DENIED if lock couldn't be found from the waiting list. 		*
 *  Note: if a lock is granted after client sends the cancel request but before	*
 *		  server receives it, a LCK_DENIED will be returned. client should		*
 *		  try to call LkMgrUnlock instead										*
 ********************************************************************************/
STATUS LkMgrCancel(
	BOOL 	 block,
	BOOL	 isExclusive,
	LkMgrLock_s *alock);


/********************************************************************************
 *	Lock Manager will search all the locks on the requested file.				*
 *  return: LCK_GRANTED if lock is found and removed from the locking list		*
 *			LCK_DENIED if lock couldn't be found from the locking list or it is *
 *			still in the waiting state.											*
 *  Note: client should call this routine if it knows the lock is granted		*
 ********************************************************************************/
STATUS LkMgrUnlock(
	LkMgrLock_s *alock,
	NINT *callerCount);


/********************************************************************************
 *	Creates a SHARE reservation on a file.										*
 ********************************************************************************/
STATUS LkMgrShare(
	BYTE 		*callerName,	/* NULL terminated byte string */
	NFSHandle_s *fh,
	NetObj_s	*oh,			
	FshMode_t	mode,
	FshAccess_t access);


/********************************************************************************
 *	Removes a SHARE reservation on a file.										*
 ********************************************************************************/
STATUS LkMgrUnshare(
	BYTE 		*callerName,	/* NULL terminated byte string */
	NFSHandle_s *fh,
	NetObj_s	*oh,			
	FshMode_t 	mode,
	FshAccess_t access);


/********************************************************************************
 *	Creates a nonmonitored byte-range lock on a file.							*
 ********************************************************************************/
STATUS LkMgrNmLock(
	BOOL	 block,
	BOOL 	 isExclusive,
	LkMgrLock_s *alock,
	SLONG	 state);


/********************************************************************************
 *	Clients has lost lock state and all server locks owned by this client		*
 *	should be freed. (This also includes to release all the share reservations	*
 *  created by this client).													*
 ********************************************************************************/
void LkMgrFreeAll(
	BYTE *callerName);		   /* NULL terminated byte string */


/********************************************************************************
 *	Clients has lost lock state and all server locks owned by this client		*
 *	with state lower than the specified number should be freed. (This also 		*
 *  includes to release all the share reservations created by this client).		*
 ********************************************************************************/
void LkMgrFreeAllWithState(
	BYTE *callerName,		   /* NULL terminated byte string */
	SLONG state);

void LkMgrCleanup();


/*-------------------------------------------------------------------------------*/
void displayLkMgrStats();
void cleanupLkMgrStats();
void startLkMgrBgCleanupThread();

STATUS initLkMgr();
void uninitLkMgr();

NINT nssToLkMgrError (NINT status);

#ifdef __cplusplus
}
#endif

#endif /* _NFSLOCKS_H_ */
