/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: ying $
 | $Date: 2005/04/01 00:05:42 $
 |
 | $RCSfile: nssPubs.h,v $
 | $Revision: 1.3 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Prototype publics for NSS
 +-------------------------------------------------------------------------*/
#ifndef _NSSPUBS_H_
#define _NSSPUBS_H_

#if zNETWARE || (zLINUX && defined(__KERNEL__))
#ifndef _ZPARAMS_H_
#include "zParams.h"
#endif
#endif

#ifndef _XMLNSS_H_
#include "xmlNSS.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define	MAX_MGMTDIR_LEN 64
/*-------------------------------------------------------------------------
 * Externs for NSS globals
 *-------------------------------------------------------------------------*/
extern unicode_t *AdminVolUnicodeName;
extern unicode_t *PersistAdminVolUnicodeName;
extern BYTE *AdminVolAsciiName;
extern NINT AdminVolNameLen;
extern BYTE AVFileMgmtDir[];
extern NINT AVFileMgmtDirLen;
extern BYTE AVFileOSMgmtDir[];
extern NINT AVFileOSMgmtDirLen;

#define SELECT_BEASTS_ALL                0x00000000
#define SELECT_BEASTS_FOR_COMPRESSION    0x00000001
#define SELECT_BEASTS_SALVAGEABLE        0x00000002
#define SELECT_BEASTS_PURGEABLE          0x00000004
#define SELECT_BEASTS_FOR_BACKUP         0x00000008
#define SELECT_BEASTS_FOR_MIGRATION      0x00000010

#define BST_INFO_ROOT           0x0001
#define BST_INFO_NAMED          0x0002
#define BST_INFO_FILE           0x0004
#define BST_INFO_COMPRESSION    0x0008
#define BST_INFO_VOLUME_SIMPLE  0x0010
#define BST_INFO_VOLUME_FULL    0x0020

/* FixFixFix6 - where should these go??? */
#define	AVOL_PERSISTENT_ADMIN_VOLUME 				MSGNot("_ADMIN_P")
#define	AVOL_PERSISTENT_ADMIN_VOLUME_UNICODE		MSGNot(L"_ADMIN_P")
#define	AVOL_ADMIN_VOLUME							MSGNot("_ADMIN")
#define	AVOL_ADMIN_VOLUME_UNICODE					MSGNot(L"_ADMIN")
#define	AVOL_MANAGEMENT_DIRECTORY					MSGNot("Manage_NSS")
#define	AVOL_MANAGEMENT_DIRECTORY_UNICODE			MSGNot(L"Manage_NSS")
#define	AVOL_POOL_DIRECTORY							MSGNot("Pools")
#define	AVOL_POOL_DIRECTORY_UNICODE					MSGNot(L"Pools")
#define	AVOL_VOLUME_DIRECTORY						MSGNot("Volumes")
#define	AVOL_VOLUME_DIRECTORY_UNICODE				MSGNot(L"Volumes")
#define	AVOL_MANAGEMENT_VOLUME_DIRECTORY			MSGNot("Volume")
#define	AVOL_MANAGEMENT_VOLUME_DIRECTORY_UNICODE	MSGNot(L"Volume")
#define	AVOL_MANAGEMENT_POOL_DIRECTORY				MSGNot("Pool")
#define	AVOL_MANAGEMENT_POOL_DIRECTORY_UNICODE		MSGNot(L"Pool")
#define	AVOL_OS_MANAGEMENT_DIRECTORY				MSGNot("Manage_OS")
#define	AVOL_OS_MANAGEMENT_DIRECTORY_UNICODE		MSGNot(L"Manage_OS")

	/* Path defines are fully named paths I.E. 'VOL:\DIR1\DIR2\...\' */
#define	AVOL_MANGEMENT_PATH					AVOL_ADMIN_VOLUME			 	\
											MSGNot(":\\")					\
											AVOL_MANAGEMENT_DIRECTORY		\
											MSGNot("\\")

#define	AVOL_MANGEMENT_PATH_UNICODE			AVOL_ADMIN_VOLUME_UNICODE	 	\
											MSGNot(L":\\")					\
											AVOL_MANAGEMENT_DIRECTORY_UNICODE \
											MSGNot(L"\\")

#define	AVOL_MANGEMENT_VOLUME_PATH_UNICODE	AVOL_MANGEMENT_PATH_UNICODE	   	\
											AVOL_MANAGEMENT_VOLUME_DIRECTORY_UNICODE \
											MSGNot(L"\\")

#define	AVOL_MANGEMENT_POOL_PATH_UNICODE	AVOL_MANGEMENT_PATH_UNICODE	   	\
											AVOL_MANAGEMENT_POOL_DIRECTORY_UNICODE \
											MSGNot(L"\\")

#define	AVOL_VOLUME_PATH_UNICODE			AVOL_ADMIN_VOLUME_UNICODE	 	\
											MSGNot(L":\\")					\
											AVOL_VOLUME_DIRECTORY_UNICODE	\
											MSGNot(L"\\")

#define	AVOL_POOL_PATH_UNICODE				AVOL_ADMIN_VOLUME_UNICODE	 	\
											MSGNot(L":\\")					\
											AVOL_POOL_DIRECTORY_UNICODE		\
											MSGNot(L"\\")

#define	AVOL_OS_MANGEMENT_PATH				AVOL_ADMIN_VOLUME			 	\
											MSGNot(":\\")					\
											AVOL_OS_MANAGEMENT_DIRECTORY		\
											MSGNot("\\")

#define	AVOL_OS_MANGEMENT_PATH_UNICODE		AVOL_ADMIN_VOLUME_UNICODE	 	\
											MSGNot(L":\\")					\
											AVOL_OS_MANAGEMENT_DIRECTORY_UNICODE \
											MSGNot(L"\\")


/*--------------------------------------------------------------------------*
 * 			Functions for virtual files
 *--------------------------------------------------------------------------*/
STATUS MGMT_MakeFunctionVirtualFile(
	Key_t key,
	utf8_t *readRoutine,
	utf8_t *readParm,
	utf8_t *writeRoutine,
	utf8_t *writeParm,
    BOOL withCookie);

STATUS MGMT_MakeCommandVirtualFileWithHelp(
	Key_t key,
	utf8_t *help,
	utf8_t *writeRoutine,
	utf8_t *writeParm);

STATUS MGMT_MakeUserCommandVirtualFileWithHelp(
	Key_t key,
	utf8_t *help,
	utf8_t *library,
	utf8_t *writeRoutine,
	utf8_t *writeParm);

STATUS MGMT_MakeCommandVirtualFile(
	Key_t key,
	utf8_t *writeRoutine,
	utf8_t *writeParm);

STATUS MGMT_MakeFunctionVirtualFileWithHelp(
	Key_t key,
	utf8_t *help,
	utf8_t *readRoutine,
	utf8_t *readParm,
	utf8_t *writeRoutine,
	utf8_t *writeParm,
    BOOL withCookie);

STATUS MGMT_CopyToWorkingBuffer(
	NINT bufLen,
	BYTE *buffer,
	NINT offset,
	VirtInfo_s *virtInfo);

STATUS MGMT_FindFirstElement(
	VirtInfo_s *virtInfo,
	utf8_t *tagName,
	NINT bufferLength,
	BYTE *buffer,
	NINT offset,
	XML_ElementInfo_s *element);

void MGMT_ReturnError(
	VirtInfo_s *virtInfo,
	utf8_t *tag,
	STATUS	error);

void VIRT_ResetResult(
	VirtInfo_s *virtInfo);

void VIRT_MakeResultsImportant(
	VirtInfo_s *virtInfo);

void VIRT_MakeResultsNormal(
	VirtInfo_s *virtInfo);

STATUS VIRT_AddResultData (
	VirtInfo_s *virtInfo,
	utf8_t *data);

STATUS VIRT_AddResultTagForAttribute (
	VirtInfo_s *virtInfo,
	utf8_t *tagName);

STATUS VIRT_AddAttribute (
	VirtInfo_s *virtInfo,
	utf8_t *attrName,
	utf8_t *attrValue,
	BOOL lastAttr,
	BOOL endTag,
	BOOL newLine);

STATUS VIRT_AddResultTag (
	VirtInfo_s *virtInfo,
	utf8_t *tagName,
	BOOL endTag,
	BOOL newLine);

STATUS VIRT_AddResultElement (
	VirtInfo_s *virtInfo,
	utf8_t *tagName,
	utf8_t *data,
	BOOL newLine);

STATUS VIRT_AddResultCDataElement (
	VirtInfo_s *virtInfo,
	utf8_t *tagName,
	utf8_t *data,
	BOOL newLine);

/*-------------------------------------------------------------------------
 * Structures
 *-------------------------------------------------------------------------*/

#if zNETWARE || (zLINUX && defined(__KERNEL__))
typedef struct VisibilityEntry_s
{
	UserID_t trusteeID;
	LONG count;
} VisibilityEntry_s;

/*-------------------------------------------------------------------------
 * Externs for NSS functions
 *-------------------------------------------------------------------------*/
extern LONG GetVisibilityCount(
		LONG volume,
		LONG *numTrustees); /** Greater than or equal to the total number of
							 ** trustees on the volume.  Allocate the trustee
							 ** vector array to be of this size and pass in
							 ** this value in the numTrustees field of the
							 ** next call.
							 **/

extern LONG GetVisibilityList(
		LONG volume,
		VisibilityEntry_s *trusteeVector,
		LONG *numTrustees);   /** Specify the trusteeVector array size **/
							  /** The returned value has the size with 
							   ** data filled in.**/


/*************************************************************************
 *
 *	This API maps the trustee IDs on all the volumes on the system
 *	from the old list speciifed by oldIDs to the new list specified
 *	by newIDs.  If callBack is non NULL and callBackFrequency is not
 *	zero, the callBack routine is called after after every n files are
 *	processed (n is the value specified by callbackFrequency)
 *	
 *	If the callBack routine returns a non-zero value the function is
 *	aborted.  This will result in a partial update of IDs and an 
 *	inconsistent state.  
 *
 ************************************************************************/
extern LONG SwitchNSSTrusteeIDs (
	LONG  	 volume,
	LONG   	 numOfTrustees,
	UserID_t *oldIDs,              			/** Array of old Trustee IDs **/
	UserID_t *newIDs,						/** Mapping into the new IDs **/
	LONG   	 callBackFrequency,				/** callback after n files processed **/
	LONG   	 (*callBack)(LONG totalCount));	/** Call back with the running
											 ** total of the files processed **/

typedef struct VisInfo_s
{
	BYTE		fileID[8];
	UserID_t	trusteeID;
	LONG		count;
} VisInfo_s;

LONG GetVisibilityInfo (
	LONG		volume,
	LONG		numAvailable,
	VisInfo_s	*visInfo,
	LONG		*numEntries);

void NSS_ResetTimeCaches();

void NSS_SetIgnoreTimeZone(
	BOOL	ignore);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _NSSPUBS_H_ */
