/****************************************************************************
 |
 |	(C) Copyright 2004  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 | $Author: vandana $
 | $Date: 2005/08/09 19:33:51 $
 |
 | $RCSfile: uneb.h,v $
 | $Revision: 1.4 $
 |
 +-------------------------------------------------------------------------*/
#ifndef _UNEB_H_73456gehY7_34f
#define _UNEB_H_73456gehY7_34f

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NEB_STATUS
#define NEB_STATUS LONG
#endif

#define UNEB_MAX_EVENT_USER_NAME_LENGTH		256
#define UNEB_MAX_EVENT_NAME_LENGTH			80

/*
 * State to manage the client registration of events.
 */

typedef struct consumerInfo {
	char    consumerName[UNEB_MAX_EVENT_USER_NAME_LENGTH];
	char    eventName[UNEB_MAX_EVENT_NAME_LENGTH];
	void    *consumerCookie;
	unsigned long   eventFlags;
	NEB_STATUS      (*callBack)(struct EventBlock *eventBlock);
	unsigned long   consumerFlags;
	unsigned int    consumerType;
	unsigned int    consumerOrder;
} consumerInfo_t;


/* 
	Defines the data that the library will pass to the kernel.
 */
typedef struct unebClientStatus_s {
	NEB_STATUS		UCS_NEBStatus;
	void			*UCS_NEBParm0;
	void			*UCS_NEBParm1;
} unebClientStatus_s;


/*
 *	int userNebDeveloper( int flag );
 *	
 *	Enables debug messages to be displayed on stderr.  To turn on pass in true (non-zero).
 *	To disable pass in false(0).  By default, debug messages are off.
 *
 *	Debug messages are enabled/disabled on a process level.
 *
 *	Returns previous setting.
 */
int userNebDeveloper( int flag );

/*
 * NEB_STATUS userNebRegisterConsumer(struct ConsumerRegistrationInfo *regInfo)
 *
 * Register the caller as a consumer based on the specified registration.
 * The semantics of this call are described in the NEB manual pages:
 * refer to the documentation for RegisterConsumer().
 *
 * While we support the NEB specified consumer registration information
 * structure, we impose a number of restrictions for user mode NEB:
 *
 * ACCESS_CONTROL_CHECK_BIT flag cannot be set in CRIConsumerFlags.
 *
 * CRIConsumerESR() and CRIConsumerCallback() should point to the same function
 * and should be non-NULL.
 *
 * The field CRIOwnerID will be ignored.
 *
 * Filters are not supported: The fields CRIFilterName, CRIFilterDataLength
 * and CRIFilterData will be ignored. CRIFilterName and CRIFilterData must
 * be NULL and CRIFilterDataLength must be 0.
 *
 * The field CRISecurityToken must be set NULL.
 *
 *
 * Calling/Exit State:
 *      The function may block.
 */

NEB_STATUS userNebRegisterConsumer(struct ConsumerRegistrationInfo *regInfo);


/*
 * int userNebUnRegisterConsumer(void *consumerID, void *userParameter)
 *
 * Unregister the consumer for the specified event.
 *
 * Calling/Exit State:
 * 	The function may block.
 */

int
userNebUnRegisterConsumer(void *consumerID, void *userParameter);


/*
 * Name of the UNEB device.
 */

#define UNEB_SERV_NAME	"/dev/userModeNebDrv"


/*
 * Marshalling format
 */
typedef struct NEBMarshallInfo_s
{
	int		NMI_SizeOf;				/* size of info (for possible variable sizes). */
	int		NMI_NumberOfOffsets;	/* Number of offsets that need to be fixed up. */
	int		NMI_Offsets[2];			/* Offsets that need to be fixed up. Kernel and user space can decide
									 * what these are relative to.
									 */
} NEBMarshallInfo_s;


/*
 * IOCTL for the user neb device.
 */

/*
 * IOCTL for the MPK RPC module
 */

#define UNEBDRV_IOCTL_MAGIC   0xa8

#define UNEBDRV_IOCTL_GET_EVENT  \
        _IOWR(UNEBDRV_IOCTL_MAGIC, 1, char *)

#define UNEBDRV_IOCTL_REGISTER_CONSUMER  \
        _IOWR(UNEBDRV_IOCTL_MAGIC, 2, char *)

#define UNEBDRV_IOCTL_UNREGISTER_CONSUMER  \
        _IOWR(UNEBDRV_IOCTL_MAGIC, 3, char *)

#define UNEBDRV_IOCTL_REPORT_STATUS  \
        _IOWR(UNEBDRV_IOCTL_MAGIC, 4, int)

#define UNEBDRV_IOCTL_MAXNR  4 

#ifdef __cplusplus
}
#endif

#endif  // #ifndef _UNEB_H_73456gehY7_34f

