/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) XML functions
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004/12/30 19:40:58 $
 |
 | $RCSfile: xmlNSS.h,v $
 | $Revision: 1.2 $
 |
 |---------------------------------------------------------------------------
 | This module contains the prototypes and structures for the XML routines
 |
 +-------------------------------------------------------------------------*/
#ifndef _XMLNSS_H_
#define _XMLNSS_H_

#ifdef __cplusplus
extern "C" {
#endif

	/**
	 **	NSS XML structures
	 **/
typedef struct XML_ElementInfo_s
{
	utf8_t	*startOfAttributes;
	utf8_t	*elementEnd;
	utf8_t	*dataStart;
	utf8_t	*dataEnd;
	NINT	dataLen;
	utf8_t	*attributeValueStart;
	utf8_t	*attributeValueEnd;
	NINT	attributeValueLen;
} XML_ElementInfo_s;

	/**
	 **	NSS XML function proto-types
	 **/
STATUS XML_BackwardFindEndTag(
	utf8_t	*tag,
	utf8_t	*cursor,
	utf8_t	*bufferStart,
	utf8_t	**startOfTag);

void XML_Display(
	utf8_t	*messageString,		/* Message to attach to display */
	utf8_t	*start,
	utf8_t	*end );

STATUS XML_FindEndOfElement(
	utf8_t				*tag,
	NINT				tagLen,
	utf8_t				*cursor,
	utf8_t				*bufferEnd,
	XML_ElementInfo_s		*elementInfo);

void XML_findEndOfNonWhiteSpace(
	utf8_t	**ptr,
	utf8_t	*endptr);

STATUS XML_ForwardFindTag(
	utf8_t	*tag,
	NINT	tagLen,
	utf8_t	*cursor,
	utf8_t	*bufferEnd,
	utf8_t	**endOfTag);

STATUS XML_GetNextTag(
	utf8_t				*bufferStart,
	utf8_t				*bufferEnd,
	XML_ElementInfo_s	*elementInfo,
	utf8_t				**tagName,
	NINT				*tagLen);

STATUS XML_GetTagElementAtCurrentLevel(
	utf8_t				*tagToFindString,
	utf8_t				*bufferStart,
	utf8_t				*bufferEnd,
	XML_ElementInfo_s 	*returnedInfo);

STATUS XML_GetTagAttribute(
	utf8_t				*attribute,
	XML_ElementInfo_s		*elementInfo);

STATUS XML_GetTagElement(
	utf8_t				*tag,
	utf8_t				*bufferStart,
	utf8_t				*bufferEnd,
	XML_ElementInfo_s		*elementInfo);

BOOL XML_isWhiteSpace(
	utf8_t	*ptr);

STATUS XML_SingleNameToUnicodeName(
	utf8_t		*startData,
	utf8_t		*endData,
	NINT		nelemsUnicodeNameBuffer,
	unicode_t	*unicodeNameBuffer,
	utf8_t		**newCursor );

STATUS XML_UTF8ToGUID(
	utf8_t		*startData,
	utf8_t		*endData,
	GUID_t		*guid,
	utf8_t		**newCursor );

STATUS XML_UTF8ToQUAD(
	utf8_t			*startData,
	utf8_t			*endData,
	QUAD			*quadValue,
	utf8_t			**newCursor );

STATUS XML_UTF8ToSQUAD(
	utf8_t			*startData,
	utf8_t			*endData,
	SQUAD			*squadValue,
	utf8_t			**newCursor );

STATUS	XML_UTF8ToUlong(
	utf8_t			*startData,
	utf8_t			*endData,
	unsigned long	*longValue,
	utf8_t			**newCursor );

void XML_skipWhiteSpace(
	utf8_t	**ptr,
	utf8_t	*endptr);



#ifdef __cplusplus
}
#endif

#endif	/* _XMLNSS_H_ */
