/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004/12/30 19:40:58 $
 |
 | $RCSfile: zPool.h,v $
 | $Revision: 1.2 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		NSS zPool... function prototypes.  This is a PUBLIC file.
 |	Used to freeze pools.
 +-------------------------------------------------------------------------*/
#ifndef _ZPOOL_H_
#define _ZPOOL_H_

#ifndef _ZPUBLICS_H_
#	include <zPublics.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* The next two structures are used to pass back
 * application specific status as related to
 * the application freeze status.
 */
typedef struct FreezeApplicationStatusEntry_s
{
	char		FASE_ApplicationName[40];
	char		FASE_ApplicationMessage[160];
	STATUS		FASE_Status;
} FreezeApplicationStatusEntry_s;

typedef struct FreezeApplicationStatus_s
{
	unsigned int	FAS_AllocatedEntries;	/* Number of entries.  Caller of
											 * zPoolFreeze must fill in.
											 */
	unsigned int	FAS_UsedEntries;		/* Number of entries that have been
											 * filled in. zPoolFreeze will set.
											 */
	unsigned int 	FAS_NeededEntries;		/* Number of entries needed to return
											 * back all registered applications
											 * status. zPoolFreeze will set.
											 */
	FreezeApplicationStatusEntry_s	FAS_Entries[1];	 /* zPoolFreeze will set. */
} FreezeApplicationStatus_s;


STATUS zPoolFreeze(
		unicode_t					*poolName,
		int							timeOutSeconds,
		FreezeApplicationStatus_s	*fas,				/* Can be NULL */
		void						**thawKey );

STATUS zPoolThaw(
		void		*thawKey,
		STATUS		opRetCode );

STATUS zPoolThawByName(
		unicode_t  	*poolName,
		STATUS		opRetCode );

STATUS zPoolThawRequired(
		void		*thawKey );

STATUS zPoolOwnershipRelease(
		void		*cookie,
		char		*who );

STATUS zPoolOwnershipGet(
		unicode_t	*poolName,
		char		*who,
		void		**cookie );


#ifdef __cplusplus
}
#endif


#endif /* _ZPOOL_H_ */



