/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	NetWare Advance File Services (PSS) Initialization module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004-12-30 12:40:58 -0700 (Thu, 30 Dec 2004) $
 | $RCSfile$
 | $Revision: 465 $
 |
 |---------------------------------------------------------------------------
 | Header to define routines used by data migration to demigrate files.
 +-------------------------------------------------------------------------*/

#ifndef _ZMIGRATE_H_
#define _ZMIGRATE_H_

#ifndef _ZOMNI_H_
#	include <zOmni.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

	/*
	 * zRegisterdemigrationFunction registers a function that will be
	 * called if the file system encounters a migrated file (the file
	 * attribute field has zFS_REMOTE_DATA_ACCESS set).  The
	 * demigrationFunction is called with three arguments:
	 *
	 *	fileKey - a key to the file that needs to be migrated.
	 *				The demigrationFunction can open additional
	 *				data streams attached to the file or to get
	 *				information about the file using zGetInfo.
	 *				The key has write permission to the file, so
	 *				the demigrationFunction can restore the data
	 *				that belongs to the file.
	 *
	 *	offset - beginning offset the request needs to be demigrated.
	 *				The demigrationFunction can choose to begin
	 *				demigration before this point in the file.
	 *
	 *	length - number of bytes starting from offset that must
	 *				be demigrated.  The demigrationFunction may
	 *				choose to demigrate more.
	 */

typedef STATUS	(*DemigrateFunc_t)(Key_t	fileKey,
									QUAD	offset,
									QUAD	length);

STATUS zRegisterDemigrateFunction(DemigrateFunc_t demigrationFunction);

STATUS zUnregisterDemigrateFunction (void);


#ifdef __cplusplus
}
#endif

#endif /* _ZMIGRATE_H_ */
