/****************************************************************************
 | $Author: taysom $
 | $Date: 2004-12-30 12:40:58 -0700 (Thu, 30 Dec 2004) $
 | $RCSfile$
 | $Revision: 465 $
 |
 |---------------------------------------------------------------------------
 | This module is used to: Posix Semantic Agent, PSA, Public Header File.
 +-------------------------------------------------------------------------*/
/*-
 * Copyright (c) 1982, 1986, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)types.h	8.4 (Berkeley) 1/21/94
 * $Id: psaPublic.h 465 2004-12-30 19:40:58Z taysom $
 */

#ifndef _PSAPUBLIC_H_
#define _PSAPUBLIC_H_

#ifndef _ZOMNI_H_
#include <zOmni.h>
#endif


/* Ensure C++ compilers generate code with unmangled linkage */
#ifdef __cplusplus
extern "C" {
#endif


                           
#ifndef _DEV_T
#define _DEV_T
typedef	unsigned long	dev_t;		/* device number */
#endif

#ifndef _GID_T
#define _GID_T
typedef	unsigned long	gid_t;		/* group id */
#endif

#ifndef _INO_T
#define _INO_T
typedef	unsigned long	ino_t;		/* inode number */
#endif

#ifndef _MODE_T
#define _MODE_T
typedef	unsigned short	mode_t;		/* permissions */
#endif

#ifndef _NLINK_T
#define _NLINK_T
typedef	unsigned short	nlink_t;	/* link count */
#endif

#ifndef _OFF_T
#define _OFF_T
typedef	SQUAD		off_t;		/* file offset */
#endif

#ifndef _SIZE_T
#define _SIZE_T
#	ifndef _SIZE_T_DEFINED
#	define _SIZE_T_DEFINED
#		ifndef _SIZE_T_DEFINED_
#		define _SIZE_T_DEFINED_
			typedef	LONG		size_t;		/* buffer sizes */
#		endif
#	endif
#endif

#ifndef _SSIZE_T
#define _SSIZE_T
typedef	SLONG		ssize_t;		/* buffer size plus return codes */
#endif

#ifndef _UID_T
#define _UID_T
typedef	unsigned long	uid_t;		/* user id */
#endif

#ifndef _TIME_T
#define _TIME_T
typedef	unsigned long	time_t;		/* time */
#endif

typedef LONG	pTicket_t;
typedef LONG	pContext_t;

/*
 * File status flags: these are used by open(2), fcntl(2).
 */
/* open-only flags */
#define	pO_RDONLY	0x0000		/* open for reading only */
#define	pO_WRONLY	0x0001		/* open for writing only */
#define	pO_RDWR		0x0002		/* open for reading and writing */
#define	pO_ACCMODE	0x0003		/* mask for above modes */

#define	pO_NONBLOCK	0x0004		/* no delay */
#define	pO_APPEND	0x0008		/* set append mode */
#define	pO_SHLOCK	0x0010		/* open with shared file lock */
#define	pO_EXLOCK	0x0020		/* open with exclusive file lock */
#define	pO_CREAT	0x0200		/* create if nonexistant */
#define	pO_TRUNC	0x0400		/* truncate to zero length */
#define	pO_EXCL		0x0800		/* error if already exists */


/*
 * Structure defined by POSIX.4 to be like a timeval.
 */

typedef struct pStat_s {
	ino_t	st_ino;		/* inode's number */
	mode_t	st_mode;	/* inode protection mode */
	nlink_t	st_nlink;	/* number of hard links */
	uid_t	st_uid;		/* user ID of the file's owner */
	time_t	st_atime;	/* time of last access */
	time_t	st_mtime;	/* time of last data modification */
	time_t	st_ctime;	/* time of last file status change */
	off_t	st_size;	/* file size, in bytes */
	quad_t	st_blocks;	/* blocks allocated for file */
	unsigned long	st_blksize;	/* optimal blocksize for I/O */
} pStat_s;

#define	pS_IFMT		0170000		/* type of file mask */
#define	pS_IFIFO	0010000		/* named pipe (fifo) */
#define	pS_IFCHR	0020000		/* character special */
#define	pS_IFDIR	0040000		/* directory */
#define	pS_IFBLK	0060000		/* block special */
#define	pS_IFREG	0100000		/* regular */
#define	pS_IFLNK	0120000		/* symbolic link */
#define	pS_IFSOCK	0140000		/* socket */

#define pUNIX_NAME_SPACE	0	/* Unix name space */
#define pLONG_NAME_SPACE	1	/* NT name space */

extern STATUS pAudit(void);

extern STATUS pNewContext(
	long		connection,
	int			nameSpace,
	const char	*volume,
	pContext_t	*pcontext);

extern void pEndContext(
	pContext_t	context);

extern STATUS pChdir(
	pContext_t	context,
	const char	*path);

extern STATUS pChmod(
	pContext_t	context,
	const char	*path,
	mode_t		mode);

extern STATUS pClose(
	pTicket_t	ticket);

extern STATUS pFstat(
    pTicket_t	ticket,
    pStat_s		*sb);

extern STATUS pGetcwd(
	pContext_t	context,
	char		*buf,
	size_t		bufSize);

extern STATUS pLink(
	pContext_t	context,
	const char	*from,
	const char	*to);

extern STATUS pOpen(
	pContext_t	context,
	const char	*path,
	int			flags,
	mode_t		mode,
	pTicket_t	*pticket);

extern STATUS pRename(
	pContext_t	context,
	const char	*from,
	const char	*to);

extern STATUS pRead(
	pTicket_t	ticket,
	off_t		offset,
	void		*buf,
	size_t		nbytes,
	size_t		*bytesRead);

extern STATUS pRealName(
	pContext_t	context,
	const char	*path,
	char		*buf,
	size_t		bufSize);

extern STATUS pStat(
	pContext_t	context,
	const char	*path,
	pStat_s		*sb);

extern STATUS pUnlink(
	pContext_t	context,
	const char	*path);

extern STATUS pWrite(
	pTicket_t	ticket,
	off_t		offset,
	const void	*buf,
	size_t		nbytes,
	size_t		*bytesWritten);

/*
 * Directory operations
 */

#define pIFTODT(_mode)	(((_mode) & pS_IFMT) >> 12)

#define pDT_UNKNOWN	0
#define pDT_FIFO	pIFTODT(pS_IFIFO)
#define pDT_CHR		pIFTODT(pS_IFCHR)
#define pDT_DIR		pIFTODT(pS_IFDIR)
#define pDT_BLK		pIFTODT(pS_IFBLK)
#define pDT_REG		pIFTODT(pS_IFREG)
#define pDT_LNK		pIFTODT(pS_IFLNK)
#define pDT_SOCK	pIFTODT(pS_IFSOCK)
//#define DT_WHT     pIFTODT(pS_IFWHT)

typedef struct pDirent_s {
    ino_t d_fileno;           /* file number of entry */
    WORD  d_type;             /* file type, see below */
    WORD  d_namlen;           /* length of string in d_name */
#define pMAXNAMLEN   (3*255)  /* Account for UTF-8 names */
    char d_name[pMAXNAMLEN + 1];  /* name must be no longer than this */
} pDirent_s;

extern STATUS pClosedir(
    pTicket_t	ticket);

extern STATUS pMkdir(
    pContext_t	context,
    const char	*path,
    mode_t		mode);

extern STATUS pOpendir(
    pContext_t	context,
    const char	*path,
    pTicket_t	*pticket);

extern STATUS pReaddir(
    pTicket_t	ticket,
    pDirent_s	*dirent);

extern STATUS pRewinddir(
    pTicket_t	ticket);

extern STATUS pRmdir(
    pContext_t	context,
    const char	*path);

#ifdef __cplusplus
}
#endif


#endif
