/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: gpachner $
 | $Date: 2005-05-13 10:53:28 -0600 (Fri, 13 May 2005) $
 |
 | $RCSfile$
 | $Revision: 980 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		NSS Library source
 +-------------------------------------------------------------------------*/
#ifndef _ZEVENT_H_
#define _ZEVENT_H_

//#include <xUnicode.h>

#ifndef _ZPARAMS_H_
#	include <zParams.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**** Event system defines and structures       */

/* "NSS.StartupCompleted"		  */

/* "NSS.Delete.Enter" 	          */
/* "NSS.Delete.Exit"  	          */
/* "NSS.Create.Enter" 	          */
/* "NSS.Create.Exit"  	          */
/* "NSS.Open.Enter"   	          */
/* "NSS.Open.Exit"    	          */
/* "NSS.Close.Enter"  	          */
/* "NSS.Close.Exit"   	          */
/* "NSS.Rename.Enter" 	          */
/* "NSS.Rename.Exit"  	          */
/* "NSS.ModifyInfo.Enter"         */
/* "NSS.ModifyInfo.Exit"          */
/* "NSS.SetDataSize.Enter"        */
/* "NSS.SetDataSize.Exit"         */
/* "NSS.AddTrustee.Enter"         */
/* "NSS.AddTrustee.Exit"          */
/* "NSS.RemoveTrustee.Enter"      */
/* "NSS.RemoveTrustee.Exit"       */
/* "NSS.SetInheritedRights.Enter" */
/* "NSS.SetInheritedRights.Exit"  */
/* "NSS.ChangeVolState.Enter"     */
/* "NSS.ChangeVolState.Exit"      */
/* "NSS.Link.Enter"               */
/* "NSS.Link.Exit"                */
/* "NSS.ChangePoolState.Enter"    */
/* "NSS.ChangePoolState.Exit"     */
/* "NSS.PoolCreate.Enter"   	  */
/* "NSS.PoolCreate.Exit"     	  */
/* "NSS.PoolDelete.Enter"    	  */
/* "NSS.PoolDelete.Exit"     	  */
/* "NSS.PoolResize.Enter"    	  */
/* "NSS.PoolResize.Exit"     	  */
/* "NSS.PoolRename.Enter"    	  */
/* "NSS.PoolRename.Exit"     	  */
/* "NSS.ChangePoolShared.Enter"	  */
/* "NSS.ChangePoolShared.Exit" 	  */
/* "NSS.LVolumeCreate.Enter"	  */
/* "NSS.LVolumeCreate.Exit"	  	  */
/* "NSS.LVolumeDelete.Enter"	  */
/* "NSS.LVolumeDelete.Exit"	  	  */
/* "NSS.LVolumeRename.Enter"	  */
/* "NSS.LVolumeRename.Exit"	  	  */
/* "NSS.LVolumeSalvage.Enter"	  */
/* "NSS.LVolumeSalvage.Exit"	  */
/* "NSS.LVolumePurge.Enter"	  	  */
/* "NSS.LVolumePurge.Exit"	      */
/* "NSS.LVolumeSnapshot.Enter"	  */
/* "NSS.LVolumeSnapshot.Exit"	  */
/* "NSS.PoolFreeze"				  */
/* "NSS.PoolThaw"				  */


#define ENTER_EVENT_SUCCESS                    0
#define ENTER_EVENT_DENIED                    -1

typedef struct TimeInfo_s
{
	Time_t accessedTime;            /* Last time file was accessed*/
    Time_t createdTime;             /* Time file was created */
    Time_t modifiedTime;            /* Last time data was changed */
    Time_t metaDataModifiedTime;    /* Last time metadata was changed. */	
} TimeInfo_s;

typedef struct EventDeleteEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
} EventDeleteEnter_s;

typedef struct EventDeleteExit_s
{
	NINT 	enterExitID;
	STATUS 	enterRetStatus;
	STATUS 	opRetCode;
} EventDeleteExit_s;

typedef struct EventCreateEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	unicode_t 	*name;
	NINT 		fileType;
	NINT 		fileAttributes;
	NINT 		createFlags;
	void 		*createParms;
	NINT 		requestedRights;
	NINT 		createAndOpen;
} EventCreateEnter_s;

typedef struct EventCreateExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	NINT 		retOpenCreateAction;
	Key_t 		retKey;
	Zid_t		retZid;
	VolumeID_t	retVolID;
	TimeInfo_s 	times;
} EventCreateExit_s;

typedef struct EventOpenEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	NINT 		requestedRights;
	void 		*openParms;
} EventOpenEnter_s;

typedef struct EventOpenExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	Key_t 		retKey;
	Zid_t		retZid;
	VolumeID_t	retVolID;
	TimeInfo_s 	times;
} EventOpenExit_s;

typedef struct EventCloseEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	Key_t 		key;
	NINT 		fhState;
	TimeInfo_s 	times;
} EventCloseEnter_s;

typedef struct EventCloseExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	NINT 		fileDeleted;
} EventCloseExit_s;

typedef struct EventRenameEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		srcZid;
	VolumeID_t	srcVolID;
	Zid_t		dstZid;
	unicode_t 	*dstName;
	NINT 		renameFlags;
} EventRenameEnter_s;

typedef struct EventRenameExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventRenameExit_s;

typedef struct EventModifyInfoEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	NINT 		modifyInfoMask;
	NINT 		modifyTypeInfoMask;
	zInfo_s 	*modifyInfo;
	void 		*modifyTypeInfo;
} EventModifyInfoEnter_s;

typedef struct EventModifyInfoExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventModifyInfoExit_s;

typedef struct EventSetDataSizeEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	Key_t 		key;
	QUAD 		curEOF;
	QUAD 		newEOF;
	NINT 		setSizeFlags;
} EventSetDataSizeEnter_s;

typedef struct EventSetDataSizeExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	QUAD 		newEOF;
} EventSetDataSizeExit_s;

typedef struct EventAddTrusteeEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	UserID_t 	trusteeID;
	NINT 		rights;
	NINT 		attributes;
} EventAddTrusteeEnter_s;

typedef struct EventAddTrusteeExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventAddTrusteeExit_s;

typedef struct EventRemoveTrusteeEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	UserID_t 	trusteeID;
	NINT 		purgedFileFlag;
} EventRemoveTrusteeEnter_s;

typedef struct EventRemoveTrusteeExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventRemoveTrusteeExit_s;

typedef struct EventSetInheritedRightsEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		zid;
	VolumeID_t	volID;
	NINT 		inheritedRights;
	BOOL 		authorizeFlag;
} EventSetInheritedRightsEnter_s;

typedef struct EventSetInheritedRightsExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventSetInheritedRightsExit_s;


typedef struct EventChangeVolStateEnter_s
{
	NINT 		enterExitID;
	WORD 		oldState;
	WORD 		newState;
	NINT 		mode;
#define zVOLMODE_MUST_SUCCEED		0x2000		/* If set, event must not be failed by check consumers. */
#define zVOLMODE_ATTRIBUTE_CHANGE	0x8000		/* If set, then event was generated to inform that some
												 * attributes changed. The 'oldState' will ALWAYS equal
												 * 'newState' when this bit is set.  In addition,
												 * zVOLMODE_MUST_SUCCEED will be set.
												 */
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventChangeVolStateEnter_s;

typedef struct EventChangeVolStateExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	WORD 		oldState;
	WORD 		newState;
	NINT 		mode;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventChangeVolStateExit_s;


typedef struct EventLinkEnter_s
{
	NINT 		enterExitID;
	NINT 		connID;
	NINT 		taskID;
	Zid_t		srcZid;
	VolumeID_t	srcVolID;
	Zid_t		dstZid;
	VolumeID_t	dstVolID;
	unicode_t 	*dstName;
	NINT 		linkFlags;
} EventLinkEnter_s;

typedef struct EventLinkExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
} EventLinkExit_s;

typedef struct EventChangePoolStateEnter_s
{
	NINT 		enterExitID;
	WORD 		oldState;
	WORD 		newState;
	NINT 		mode;
	VolumeID_t	poolID;
} EventChangePoolStateEnter_s;

typedef struct EventChangePoolStateExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	WORD 		oldState;
	WORD 		newState;
	NINT 		mode;
	VolumeID_t	poolID;
} EventChangePoolStateExit_s;

typedef struct EventPoolCreateEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*poolName;
	BOOL		shared;
} EventPoolCreateEnter_s;

typedef struct EventPoolCreateExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;
} EventPoolCreateExit_s;

typedef struct EventPoolDeleteEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;
} EventPoolDeleteEnter_s;

typedef struct EventPoolDeleteExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;
} EventPoolDeleteExit_s;

typedef struct EventPoolFreeze_s
{
	NINT 		enterExitID;	/* Id to match paired 'freeze' and 'thaw'
								 * events.
								 */
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;			/* True if a clustered pool */
	NINT		timeOutSeconds;	/* Number of seconds that freeze must complete in */
	void		*key;			/* Key to pass to PoolNotify and PoolNotifyQueistRequired */
	STATUS 		(*poolEventReceived)(
					void		*key,
					void		*nebConsumerId );
								/* Function to call right when you recieve a
								 * freeze event.  Must be called once and only
								 * once for each 'Freeze' event.
								 */
	STATUS 		(*poolNotifyQuiescent)(
					void		*key,
					void		*nebConsumerId,
					STATUS		completionCode,
					char		*applicationName,
					char		*applicationMessage );
								/* Function to call when you have made
								 * your data consistent.  Must be called
								 * once and only once for each 'Freeze'
								 * event.
								 */
	STATUS 		(*poolNotifyQuiescentRequired)(
					void		*key,
					void		*nebConsumerId );
  								/* Use this function if your application takes
  								 * a while (more than a second) to Quiescent its
  								 * data.  When this function returns non-zero
  								 * your application must stop its quiescent
  								 * attempt and call poolNotifyQuiescent.
								 * In this case call poolNotifyQuiescent with the
								 * return code from poolNotifyQuiescentRequired as
								 * 'completionCode'.
								 *
   								 * This function should be called at least 2 times
   								 * a second between the app recieving a freeze EVENT
								 * and the apps call to poolNotifyQuiescent.
								 * Once poolNotifyQuiescent is called you MUST
								 * not call PoolNotifyRequired again.
								 *
								 * This function returns non-zero when the user
								 * wishes to deactivate the pool or the timeout
								 * for the freeze has expired.
								 */

} EventPoolFreeze_s;

typedef struct EventPoolThaw_s
{
	NINT 		enterExitID;	/* Id to match paired 'freeze' and 'thaw'
								 * events.
								 */
	STATUS 		opRetCode;		/* Return code from the caller of zPoolFreeze. */
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;			/* True if a clustered pool */
	void		*key;
} EventPoolThaw_s;

typedef struct EventPoolResizeEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;
	QUAD		addSectors;
} EventPoolResizeEnter_s;

typedef struct EventPoolResizeExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;
	QUAD		newSizeInSectors;
} EventPoolResizeExit_s;

typedef struct EventPoolRenameEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*oldName;
	unicode_t 	*newName;
	VolumeID_t	poolID;
	BOOL		shared;
} EventPoolRenameEnter_s;

typedef struct EventPoolRenameExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*oldName;
	unicode_t 	*newName;
	VolumeID_t	poolID;
	BOOL		shared;
} EventPoolRenameExit_s;

typedef struct EventChangePoolSharedEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;	 /* TRUE if shared state is requested */
} EventChangePoolSharedEnter_s;

typedef struct EventChangePoolSharedExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*poolName;
	VolumeID_t	poolID;
	BOOL		shared;		/* Final state of shared */
} EventChangePoolSharedExit_s;

typedef struct EventLVolCreateEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*volName;
	QUAD		volSize;
	VolumeID_t	poolID;
} EventLVolCreateEnter_s;

typedef struct EventLVolCreateExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*volName;
	VolumeID_t	volID;
	QUAD		volSize;
	VolumeID_t	poolID;
} EventLVolCreateExit_s;

typedef struct EventLVolDeleteEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*volName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolDeleteEnter_s;

typedef struct EventLVolDeleteExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	VolumeID_t	oldVolID;   /* Note: During delete vol may get a new GUID */
	VolumeID_t	newVolID;
	VolumeID_t	poolID;
} EventLVolDeleteExit_s;

typedef struct EventLVolRenameEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*oldName;
	unicode_t 	*newName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolRenameEnter_s;

typedef struct EventLVolRenameExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*volName;    /* final name (new or old based on 
							  * if rename was successful) */
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolRenameExit_s;

typedef struct EventLVolSalvageEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*volName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolSalvageEnter_s;

typedef struct EventLVolSalvageExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*volName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolSalvageExit_s;

typedef struct EventLVolPurgeEnter_s
{
	NINT 		enterExitID;
	unicode_t 	*volName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolPurgeEnter_s;

typedef struct EventLVolPurgeExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	unicode_t 	*volName;
	VolumeID_t	volID;
	VolumeID_t	poolID;
} EventLVolPurgeExit_s;

typedef struct EventLVolSnapshotEnter_s
{
	NINT 		enterExitID;
	LONG		volPersistentState;	/* Persistent state of volume.  A three
									 * indicates that the two deleted
									 * items are valid.
									 */
	unicode_t 	*oldVolName;		/* Old volume name. */
	unicode_t 	*oldPoolName;		/* Old Pool name. */
	unicode_t 	*poolName;			/* Current Pool Name. */
	VolumeID_t	oldPoolID;			/* Old Pool ID */
	VolumeID_t	poolID;				/* Current Pool ID */
	VolumeID_t	oldVolID;			/* Old volume ID */
	GUID_t		snapshotID;			/* Snapshot's unique ID */
		/* Enter event handlers can change the values of the next four
		 * items.  When an event is recieved these fields have want ZLSS
		 * will use unless the event handler changes.  The event handler
		 * SHOULD change the 'volumeName' as ZLSS defaults to a unicode
		 * converted GUID as the name.  If 'volPersistentState' indicates
		 * that the two deleted items are present then they can be changed.
		 * Generally, the two deleted items should not be changed from what
		 * is supplied.  The deleted items may be used in user interfaces
		 * when a deleted volume is salvaged.  In this case, the
		 * deletedVolName will be used as the default name to salvage the
		 * volume to.  For example, if you are mangling names by adding
		 * L"_SS" you may wish to added the "_SS" to the deletedVolName.
		 * If you prompt the user for 'new' volume names then I would
		 * just skip filling in a new 'deletedVolName' as the supplied
		 * volume value is good enough is they decide to salvage the
		 * snapshot volume.  Remember, the 'deletedVolName" is only
		 * a default value to use in a salvage UI.  If the name conflicts
		 * with a volume the UI will let the user know.
		 */
	VolumeID_t	volID;				/* Requested volume ID */
	unicode_t	volName[64];		/* Requested volume name */
	VolumeID_t	deletedVolID;		/* Requested deleted volume ID */
	unicode_t	deletedVolName[64];	/* Requested deleted volume name */
} EventLVolSnapshotEnter_s;

typedef struct EventLVolSnapshotExit_s
{
	NINT 		enterExitID;
	STATUS 		enterRetStatus;
	STATUS 		opRetCode;
	LONG		volPersistentState;	/* Persistent state of volume */
	unicode_t 	*oldVolName;		/* Old volume name. */
	unicode_t 	*oldPoolName;		/* Old Pool ID. */
	unicode_t 	*poolName;			/* Current Pool name. */
	VolumeID_t	oldPoolID;			/* Old Pool ID */
	VolumeID_t	poolID;				/* Current Pool Name */
	VolumeID_t	oldVolID;			/* Old volume ID */
	GUID_t		snapshotID;			/* Snapshot's unique ID */
		/* Exit event handlers MUST not these items. */
	VolumeID_t	volID;				/* Current volume ID */
	unicode_t	volName[64];		/* Current volume name */
	VolumeID_t	deletedVolID;		/* Requested deleted volume ID */
	unicode_t	deletedVolName[64];	/* Requested deleted volume name */
} EventLVolSnapshotExit_s;

#ifdef __cplusplus
}
#endif

#endif
