/****************************************************************************
 |
 |	(C) Copyright 2006  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: blarsen $
 | $Date: 2006-11-14 16:27:17 -0700 (Tue, 14 Nov 2006) $
 |
 | $RCSfile$
 | $Revision: 1644 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Define the WHERE macro for printing file and line number.
 +-------------------------------------------------------------------------*/
#ifndef _ZWHERE_H_
#define _ZWHERE_H_ 1

/*-------------------------------------------------------------------------
 * MAGIC_STRING lets the preprocessor convert an integer to a string
 * MAKE_STRING provides the level indirection need to fake out the
 *		the preprocessor
 * WHERE a string with both the file name and line number concatenated
 *		into a single string
 *-------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

#undef MAGIC_STRING
#undef MAKE_STRING
#undef WHERE

#define MAGIC_STRING(_x_)	# _x_
#define MAKE_STRING(_x_)	MAGIC_STRING(_x_)
#ifdef FNAM_
#define WHERE	FNAM_ "[" MAKE_STRING(__LINE__) "]"
#else
#define WHERE	__FILE__ "[" MAKE_STRING(__LINE__) "]"
#endif

#ifdef __cplusplus
}
#endif

#endif
