/****************************************************************************
 |
 |	(C) Copyright 2005 Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 Novell Storage Services (NSS) support module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: vandana $
 | $Date: 2006-11-13 17:27:30 -0700 (Mon, 13 Nov 2006) $
 |
 | $RCSfile$
 | $Revision: 1632 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Defines the <name, value> pairs for the netware extended attributes.
 +-------------------------------------------------------------------------*/

#ifndef _ZXATTR_H_
#define _ZXATTR_H_ 1

#ifndef _ZOMNI_H_
#include <zOmni.h>
#endif

#define zNW_PREFIX		"netware."
#define zNW_NCPSTAT		zNW_PREFIX "ncpstat"
#define zNW_QUOTA		zNW_PREFIX "quota"
#define zNW_METADATA	zNW_PREFIX "metadata"
#define zNW_USERQUOTA	zNW_PREFIX "userquota"
//#define zNW_TRUSTEE		zNW_PREFIX "trustee"

#define zNW_BYTEORDER			0xfeff
#define zNW_NCPSTAT_VERSION		1
#define zNW_QUOTA_VERSION		2
#define zNW_METADATA_VERSION	1
#define zNW_USERQUOTA_VERSION	1
//#define zNW_TRUSTEE_VERSION		1

#define zNW_ALLOWED_MODIFY_FLAGS	(zMOD_FILE_ATTRIBUTES		\
										| zMOD_CREATED_TIME		\
										| zMOD_MODIFIED_TIME	\
										| zMOD_ACCESSED_TIME)

typedef struct zNW_ncpstat_s {
	WORD	nws_byteorder;
	WORD	nws_version;
	LONG	nws_reserved_1;
	QUAD	nws_info_mask;		/* Modify information indicated by mask
								 * (see zParams.h zMOD_*) */
	QUAD	nws_file_attributes;/* All the NSS file attributes
								 * (see zParams.h) */
	QUAD	nws_file_attr_mask;	/* All the NSS file attributes */
	QUAD	nws_zid;			/* File ID, for hard links, this will be
								 * the secondary zid */
	QUAD	nws_zid_primary;	/* Primary ZID */
	QUAD	nws_zid_parent;		/* File id of parent */
	GUID_t	nws_volume_id;		/* 128 bit volume id */
	QUAD	nws_size_logical;	/* Logical size of the file in bytes */
	QUAD	nws_size_physical;	/* Physical size of the file in bytes */

	QUAD	nws_created;		/* UTC time created */
//	QUAD	nws_archived;
	QUAD	nws_modified;		/* UTC time modified */
	QUAD	nws_accessed;		/* UTC time last accessed */
//	QUAD	nws_metaDataModified;
} zNW_ncpstat_s;

typedef struct zNW_quota_V1_s {
	WORD	nwq_byteorder;
	WORD	nwq_version;
	LONG	nwq_reserved_1;
	QUAD	nwq_user_used;	/* Quota used by user */
	QUAD	nwq_user_limit;	/* Quota limit assigned to user */
	QUAD	nwq_dir_left;	/* Quota min left in directory ancestors */
} zNW_quota_V1_s;

typedef struct zNW_quota_s {
	WORD	nwq_byteorder;
	WORD	nwq_version;
	LONG	nwq_reserved_1;
	QUAD	nwq_user_used;	/* Quota used by user */
	QUAD	nwq_user_limit;	/* Quota limit assigned to user */
	QUAD	nwq_dir_left;	/* Quota min left in directory ancestors */
	QUAD	nwq_dir_quota;	/* Quota set on the directory */
} zNW_quota_s;

/* 
 * We have picked a value for zMAX_TRUSTEES that will let the 
 * structure fit in 64K.
 */
#define zMAX_TRUSTEES	2043

typedef struct zNW_trustee_s {
	GUID_t	nwt_id;
	QUAD	nwt_rights;
	QUAD	nwt_reserved_2;
} zNW_trustee_s;

typedef struct zNW_metadata_s {
	WORD	nwm_byteorder;
	WORD	nwm_version;
	LONG	nwm_reserved_1;
	QUAD	nwm_modify_mask;
	QUAD	nwm_file_attributes;
	QUAD	nwm_file_attributes_mask;

	QUAD	nwm_time_created;
	QUAD	nwm_time_archived;
	QUAD	nwm_time_modified;
	QUAD	nwm_time_accessed;

	QUAD	nwm_time_meta_data_modified;
	QUAD	nwm_reserved_2;
	GUID_t	nwm_id_owner;

	GUID_t	nwm_id_archiver;
	GUID_t	nwm_id_modifier;

	GUID_t	nwm_id_metadata_modifier;
	SQUAD	nwm_quota_limit;
	LONG	nwm_inherited_rights_mask;
	LONG	nwm_trustee_num;

	zNW_trustee_s	nwm_trustee[zMAX_TRUSTEES];
} zNW_metadata_s;

/* 
 * We have picked a value for zMAX_USERS that will let the 
 * structure fit in 64K.
 */
#define zMAX_XATTR_USERS	2047

typedef struct zNW_user_restriction_s {
	GUID_t		nwur_user;
	SQUAD		nwur_restriction;
	QUAD		nwur_reserved_2;
} zNW_user_restriction_s;

typedef struct zNW_user_quota_s {
	WORD	nwuq_byteorder;
	WORD	nwuq_version;
	LONG	nwuq_num_users;
	LONG	nwuq_index;
	LONG	nwuq_reserved_1;

	zNW_user_restriction_s nwuq_user[zMAX_XATTR_USERS];
} zNW_user_quota_s;


#if 0
#define	zMAX_FDN_NAME				256
#define zMAX_XATTR_USERS			124

typedef struct zNW_user_restriction_s {
	QUAD		nwur_restriction;
	QUAD		nwur_reserved_2;
	unicode_t	nwur_dnsname[zMAX_FDN_NAME];
} zNW_user_restriction_s;

typedef struct zNW_user_quota_s {
	WORD	nwuq_byteorder;
	WORD	nwuq_version;
	LONG	nwuq_num_users;
	LONG	nwuq_index;
	LONG	nwuq_reserved_1;

	zNW_user_restriction_s nwuq_user[zMAX_XATTR_USERS];
} zNW_user_quota_s;

typedef struct zNW_user_trustee_s{
	QUAD		nwut_rights;
	QUAD		nwut_reserved_2;
	unicode_t	nwut_dnsname[zMAX_FDN_NAME];
} zNW_user_trustee_s;

typedef struct zNW_trustee_name_s {
	WORD	nwtn_byteorder;
	WORD	nwtn_version;
	LONG	nwtn_num_trustees;
	LONG	nwtn_index;
	LONG	nwtn_reserved_1;

	zNW_user_trustee_s nwtn_user[zMAX_XATTR_USERS];
} zNW_trustee_name_s;
#endif

#endif
