/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |  $RCSfile$
 |  $Date: 2004-12-31 01:10:58 +0530 (Fri, 31 Dec 2004) $
 |  $Revision: 465 $
 |
 +***************************************************************************/

#ifndef _NEBPUB_H_
#define _NEBPUB_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __NKEVENT_H__

extern LONG GetConsumerName(
		void *consumerID,
		BYTE *consumerName);

extern struct EventBlock *GetEventBlocks(
		void *ownerID,
		LONG numberOfEventBlocksToGet);

extern LONG GetProducersEventName(
		void *producerID,
		BYTE *eventName);

extern LONG GetProducerName(
		void *producerID,
		BYTE *producerName);

extern LONG ReturnEventBlocks(
		struct EventBlock *eventBlock);

extern LONG ProduceEvent(
		struct EventBlock *eventBlock);

extern LONG RegisterConsumer(
		struct ConsumerRegistrationInfo *regConsumer);

extern LONG RegisterFilter(
		struct FilterRegistrationInfo *regFilter);

extern LONG RegisterProducer(
		struct ProducerRegistrationInfo *regProducer);

extern LONG UnRegisterConsumer(
		void *consumerID,
		void *userParameter);

extern LONG UnRegisterFilter(
		void *filterID);


extern LONG UnRegisterProducer(
		void *producerID,
		void *userParameter);

#endif

#ifdef __cplusplus
}
#endif

#endif
