/****************************************************************************
 |
 |	(C) Copyright 2001, 2004-2006, 2008, 2010, 2014  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Storage Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: kpraveen $
 | $Date: 2014-12-16 11:46:47 +0530 (Tue, 16 Dec 2014) $
 |
 | $RCSfile$
 | $Revision: 5342 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Define the message structures used by NSS and the bit masks and
 |		other values used by NSS APIs.
 +-------------------------------------------------------------------------*/
#ifndef _ZFSMSG_H_
#define _ZFSMSG_H_

#ifndef _ZOMNI_H_
#	include <zOmni.h>
#endif

#ifndef _ZMSG_H_
#	include <zMsg.h>
#endif

#ifndef _CHUNK_H_
#	include <chunk.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*
 * File System Message Structures:
 * The following message structures support the specific requests needed
 * by the NSS file system.
 *
 * The NSS Message has been designed to be fixed length with pointers to two
 * variable lenth sections, one read-only and one read/write. Read and write
 * I/O requests fit in a simple message. However, open/create requests and
 * getting/setting meta-data are more complicated.  We want to minimize the
 * scatter gather operations.
 *
 * I'm not sure how call backs work in this whole thing.  In Oryx/Pecos,
 * call backs would be handled as asyncronous messages.
 *
 * The number of bytes to read/write and the buffer pointer are
 * in the DataArea.
 */


/****************************************************************/

	/*
	 * NSS operations
	 */
typedef enum NSSops_e
{
	NSS_RESOLVE_FILEHANDLE,

	NSS_ABORTXACTION,
	NSS_ADDTRUSTEE,
	NSS_ASYNCREAD,
	NSS_BEGINTASK,
	NSS_BEGINXACTION,
	NSS_CHANGECONNECTION,
	NSS_COMMITXACTION,
	NSS_CREATE,
	NSS_DELETE,
	NSS_DELETETRUSTEE,
	NSS_DIOREAD,
	NSS_DIOWRITE,
	NSS_ENDTASK,
	NSS_FLUSH,
	NSS_GETFILEMAP,
	NSS_GETINFO,
	NSS_GETINHERITEDRIGHTSMASK,
	NSS_GETTRUSTEE,
	NSS_ISNSS,
	NSS_LINK,
	NSS_LOCKBYTERANGE,
	NSS_MODIFYINFO,
	NSS_OPEN,
	NSS_ZID_OPEN,
	NSS_READ,
	NSS_RENAME,
	NSS_SETEOF,
	NSS_SETINHERITEDRIGHTSMASK,
	NSS_START_ASYNCREAD,
	NSS_UNLOCKBYTERANGE,
	NSS_WILDREAD,
	NSS_WILDREWIND,
	NSS_WRITE,
/*
 * Place all new interfaces at the end so we don't break older
 * versions of libzapi.a
 * Make sure to update libzapi.a when adding new APIs.
 */
	NSS_ENUMERATE,
	NSS_GET_EFFECTIVE_RIGHTS,
	NSS_ZID_DELETE,
	NSS_ZID_CREATE,
	NSS_ZID_LINK,
	NSS_ZID_RENAME,
	NSS_FILE_CONTROL,
	NSS_GETINFOBYNAME,
	NSS_MODIFYINFOBYNAME,
	NSS_NEWCONNECTION,

	NSS_NUM_METHODS
} NSSops_e;

typedef enum FcntlOps_e
{
	FCNTL_SHARED_OPLOCK,
	FCNTL_ADJUST_QUOTA_FILELEN,
	FCNTL_GET_MY_ZID,

	FCNTL_NUM_METHODS
} FcntlOps_e;

enum
{
	RW_DATA      = 0,
	INFO_DATA    = 0,
	PATH_DATA    = 0,
	MAP_DATA     = 0,
	DIO_DATA     = 0,
	AUTH_DATA    = 0,
	FDN_DATA     = 0,

	PATTERN_DATA = 1,
	DSTPATH_DATA = 1,
	PATH_FOR_INFO_DATA = 1,
	BLOB_DATA    = 1
};

enum InternalFlag_t
{
	RETURN_FILEHANDLE = 0x1,
	READ_RETRY        = 0x2,
	HAVE_VOLUME_ID    = 0x4,
	USE_SHAP_SHOT     = 0x8,
	EDIR_TRUSTEE_ONLY = 0x10
};

enum Limits_t
{
	CHUNK_SHIFT = 5,
	MAX_CHUNKS = (1 << CHUNK_SHIFT),
	CHUNK_MASK = (MAX_CHUNKS - 1)
};

typedef struct zNSSMsg_s
{
	mSystemMsg_s	sys;
	union NSSbody_u
	{
		mBody_u		std;

		struct conn_s
		{
			LONG	connID;			/* Connection ID				*/
		} conn;

		struct id_s
		{
			Xid_t	xid;			/* Transaction ID				*/
			LONG	taskID;			/* Task ID (picked by user)		*/
			LONG	internalFlags;	/* Flags user does not see		*/
			QUAD	externalFlags;	/* Flags user sets in interface	*/
			LONG	sa;				/* Semantic agent ID			*/
			LONG	padding;
		} id;

		struct fcntl_s	/* File Control */
		{
			struct id_s	id;

			BYTE	opCode;			/* File control opcode			*/
			BYTE	reserved[3];
			LONG	userData[2];	/* User data					*/
			LONG	padding;
			SQUAD	quotaAdjustFactor; /* add this adjustment value to filelen for quota adjustments */
			Zid_t	zid;
		} fcntl;

		struct beginX_s
		{
			struct id_s	id;

			Xid_t	retXid;
		} beginX;

		struct readWrite_s	/* Read, Write, SetEOF, lock, unlock */
		{
			struct id_s	id;

			QUAD	startingOffset;	/* Offset into data stream			*/
			QUAD	length;			/* Lock length						*/

			LONG	timeout;		/* Milliseconds to wait for a lock	*/
			LONG	numBytes;		/* Num bytes remaining to read/write*/
			LONG	totalBytes;		/* Total num bytes read/written		*/
			LONG	padding;
		} rw;

		struct read_s	/* Chunky Read */
		{
			struct id_s	id;

			QUAD	startingOffset;	/* Offset into data stream			*/
			LONG	numBytes;		/* Number of bytes to Read			*/
			LONG	maxChunks;		/* Maximum number of chunks to use	*/

			LONG	numChunks;		/* Number of chunks returned		*/
			LONG	bytesRead;		/* Number of bytes read				*/
		} read;

		struct info_s	/* GetInfo, ModifyInfo */
		{
			struct id_s	id;

			LONG	version;
			LONG	padding;
		} info;

		struct fileMap_s
		{
			struct id_s	id;			/* Extent list format				*/

			QUAD	offset;			/* Offset into data stream			*/
			QUAD	retEndingOffset;
			LONG	extentListFormat;
			LONG	retExtentListCount;
		} map;

		struct dio_s	/* DIORead and DIOWrite */
		{
			struct id_s	id;

			QUAD	unitOffset;			/* Starting unit to begin op	*/
			QUAD	callBackContext;
		} dio;

		struct async_s
		{
			struct id_s	id;

			QUAD	startingOffset;		/* Starting offset in file	*/
			QUAD	bytesToRead;		/* Number of bytes to read	*/
			QUAD	retEof;				/* Size of file (End-Of-File)*/
			LONG	retActualBytes;		/* Actual number of bytes	*/
			LONG	padding;
			QUAD	callbackContext;
		} async;

		struct wild_s
		{
			struct id_s	id;

			LONG	version;
			LONG	characterCode;
			LONG	nameType;
			LONG	match;
			QUAD	cookie;			/* I/O Cookie for starting enumeration */
		} wild;

		struct auth_s
		{
			struct id_s	id;
			zNW_user_s trustee;	/* eDir GUID or AD SID of trustee we are working with	*/
			LONG	rights;		/* Rights for trustee.					*/
			LONG	attributes;	/* Attributes (not currently used)		*/
			LONG	sequence;	/* Sequence number of next trustee		*/
			LONG	inheritedRightsMask;
		} auth;
			/*
			 * Need to get rid of name_s, or make it more common.
			 */
		struct name_s		/* all naming, Context */
		{
			struct id_s	id;

			LONG		nameSpace;	/* Format of the path name		*/
			LONG		padding;
		} name;

		struct create_s
		{
			struct name_s	name;
	
			LONG	requestedRights;	/* Rights on the open file	*/
			LONG	fileType;			/* Type of file to create	*/
			LONG	fileAttributes;		/* Attributes for file		*/
			LONG	padding;
		} create;

		struct delete_s
		{
			struct name_s	name;

			LONG	match;		/* Match Attributes			*/
			LONG	padding;
		} delete;

		struct open_s
		{
			struct name_s	name;

			LONG	requestedRights;	/* Rights on the open file	*/
			LONG	padding;
		} open;

		struct infoByName_s				/* GetInfoByName, ModifyInfoByName */
		{
			struct name_s	name;

			LONG	version;
			LONG	padding;
		} infoByName;

		struct byZid_s
		{
			struct name_s	name;

			VolumeID_t	volumeID;
			Zid_t		zid;
			Zid_t		dstZid;				/* Destination parent for																 * link and rename */
			LONG		requestedRights;	/* Rights on the open file	*/
			LONG		fileType;			/* Type of file to create	*/
			LONG		fileAttributes;		/* Attributes for file		*/
			LONG		padding;
		} byZid;

		struct srcDst_s	/* HardLink, Rename */
		{
			struct name_s	name;

			LONG	srcMatch;
			LONG	nameSpace;
		} dst;
			/*
			 * The following structures are for supporting backwards
			 * compatibility.
			 */
		struct startAsync	/* Start asynchronous I/O operations */
		{
			struct id_s	id;

			QUAD	startingOffset;
		} start;


		/* Structure to carry get effective rights arguments */
		struct getEffRights_s
		{
			zNW_user_s objID;	/* DS object GUID to get effective rights for */
			LONG	effRights;	/* Place to store effective rights value for the object */
			LONG	padding;
		} getEffRights;

	} body;
} zNSSMsg_s;


#ifdef __cplusplus
}
#endif

#endif /* _ZFSMSG_H_ */
