/*
 * Micro Focus common branding script
 *
 * Copyright (C) 2010, 2011, 2012 Micro Focus.
 * All rights reserved.
 */

// Initialize for branding.
function mf_initUrl() {

  // quit if this function has already been called
  if (typeof mf_initUrl.done != "undefined")
    return true;

  // flag this function so we don't do the same thing twice
  mf_initUrl.done = true;

  // This script must be able to find the reference to itself in the HTML
  // document. To do this, please set uriThis to the correct path for
  // the script within the output .mshc file.
  var uriThis = "mfcommon.js";

  // What is our URI? Search the scripts included in this document.
  window.mf_uriRootPrefix = "";
  window.mf_uriRootSuffix = "";
  
  // Get all the script elements.
  var elemBrandingScripts = document.documentElement.getElementsByTagName("script");
  for (var i = 0; i < elemBrandingScripts.length; ++i) {
    // Bug in IE8. Can be an execption reading a attribs
    try {
      // Get the URI of the script.
      var uriBranding = elemBrandingScripts[i].src;

      // Strip off the branding script to get the root URI.
      var posBranding = uriBranding.indexOf(uriThis);
      if (posBranding >= 0) {
        window.mf_uriRootPrefix = uriBranding.substring(0, posBranding);

        // Look for any parameters after the script name.
        var posSuffix = uriBranding.indexOf("&", posBranding);
        if (posSuffix >= 0) {
          window.mf_uriRootSuffix = uriBranding.substring(posSuffix);
        }

        break;
      }
    } catch(e) {
      continue;   // Ignore the error. Nothing much we can do.
    }
  }

  return true;
}

function mf_makeImageUrl(image, addUrl) {
  if (typeof window.mf_uriRootPrefix == "undefined") {
    mf_initUrl();
  }

  var img = window.mf_uriRootPrefix + image + window.mf_uriRootSuffix;

  if (addUrl) {
    return "url('" + img + "')";
  } else {
    return img;
  }
}

// Code credit: Simon Wilson
// 'Stacking' onLoad handler.
function mf_addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}

// Code credit: Simon Wilson, John Resig, and others.
// Document 'onLoad' registration.
function mf_addBranding(func, funcName) {

  /* for Mozilla */
  if (document.addEventListener) {
    document.addEventListener("DOMContentLoaded", func, false);
  }

  /* for Internet Explorer */
  /*@cc_on
    document.write("<script id=__ie_onload_" + funcName + " defer src=javascript:void(0)><\/script>");
    var script = document.getElementById("__ie_onload_" + funcName);
    script.onreadystatechange = function() {
      if (this.readyState == "complete") {
        func(); // call the onload handler
      }
    };
  @*/

  /* for Safari */
  if (/WebKit/i.test(navigator.userAgent)) { // sniff
    var _timer = setInterval(function() {
      if (/loaded|complete/.test(document.readyState)) {
        clearInterval(_timer);
        func(); // call the onload handler
      }
    }, 10);
  }

  /* for other browsers */
  mf_addLoadEvent(func);
}
