# Implementation details

All source code located in the [src/](src/) folder.

Following quickstart example is used as an initial project: 
https://github.com/wildfly/quickstart/tree/17.0.1.Final/spring-resteasy

There are 3 key files:
* [XProgramBean](src/main/java/org/jboss/as/quickstarts/resteasyspring/XProgramBean.java) executes configured command line program in the specified working directory and returns program execution output.
* [XProgramSpringResource](src/main/java/org/jboss/as/quickstarts/resteasyspring/XProgramSpringResource.java) process POST requests to the XProgram bean:
```java
@Autowired
XProgramBean xProgramBean;

@POST
@Path("xprogram")
@Consumes("text/plain")
@Produces("text/plain")
public Response postXProgram(String body) {
    String result = xProgramBean.process(body);
    return Response.ok(result).build();
}

@POST
@Path("/xprogram-form")
@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
public Response postXProgramForm(@FormParam("msg") String msg) {
    String result = xProgramBean.process(msg);
    return Response.ok(result).build();
}
```
* [applicationContext.xml](src/main/webapp/WEB-INF/applicationContext.xml) where you can configure path to the executable script
```xml
<!-- XProgram bean -->
<bean id="xProgramBean" class="org.jboss.as.quickstarts.resteasyspring.XProgramBean">
    <!-- Program execution working directory -->
    <constructor-arg index="0" type="java.lang.String" value="/vagrant/cobol/webservices/xholidays" />
    <!-- Program to execute -->
    <constructor-arg index="1" type="java.lang.String" value="/vagrant/cobol/webservices/xholidays/run.sh" />
</bean>

<!-- JAX-RS XProgram resource -->
<bean id="xProgramSpringResource" class="org.jboss.as.quickstarts.resteasyspring.XProgramSpringResource" />
```

## How to build?

[Apache Maven](https://maven.apache.org/) is required to build the project with using following command:
```
mvn clean package
```
Result __spring-resteasy.war__ web application will be available in __target__ folder.
